import { prisma } from "../../lib/prisma.js";
function generateRoomCode(length = 6) {
    const chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    let result = "";
    for (let i = 0; i < length; i++) {
        result += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    return result;
}
async function generateUniqueCode() {
    let code;
    let exists = true;
    while (exists) {
        code = generateRoomCode();
        const room = await prisma.room.findUnique({
            where: { code },
        });
        if (!room)
            exists = false;
    }
    return code;
}
export async function createRoom(data) {
    const code = await generateUniqueCode();
    return prisma.room.create({
        data: {
            code,
            name: data.name,
            eventDateTime: data.eventDateTime,
            orderDeadline: data.orderDeadline,
            place: data.place,
            menuItems: {
                create: data.menuItems,
            },
        },
        include: {
            menuItems: true,
        },
    });
}
export async function getRoomByCode(code) {
    const room = await prisma.room.findUnique({
        where: { code },
        include: {
            menuItems: true,
            orders: {
                orderBy: {
                    createdAt: "asc",
                },
                include: {
                    items: true,
                },
            },
        },
    });
    if (!room)
        throw new Error("Room not found");
    return room;
}
