import * as orderService from "./order.service.js";
export async function createOrUpdateOrder(req, res) {
    try {
        const order = await orderService.createOrUpdateOrder(req.body);
        res.json(order);
    }
    catch (err) {
        res.status(400).json({ message: err.message });
    }
}
export async function deleteOrder(req, res) {
    try {
        await orderService.deleteOrder(req.body);
        res.json({ message: "Order deleted" });
    }
    catch (err) {
        res.status(400).json({ message: err.message });
    }
}
