import express from "express";
import cors from "cors";
import { prisma } from "./lib/prisma.js";
import roomRoutes from "./modules/room/room.routes.js";
import orderRoutes from "./modules/order/order.routes.js";
const app = express();
app.use(cors());
app.use(express.json());
// Health check
app.get("/", (req, res) => {
    res.json({ status: "ok" });
});
app.get("/health/db", async (req, res) => {
    await prisma.$queryRawUnsafe("SELECT 1");
    res.json({ db: "ok" });
});
app.use("/api/rooms", roomRoutes);
app.use("/api/orders", orderRoutes);
export default app;
